# SMK Negeri 1 Majalengka Website

Website sekolah SMK Negeri 1 Majalengka yang dikembangkan menggunakan teknologi [PHP](https://www.php.net/), [Laravel 10](https://laravel.com/docs/10.x), [Tailwindcss](https://tailwindcss.com/).

## Clone Project

Pastikan anda sudah menginstall [Git](https://git-scm.com/), [Composer](https://getcomposer.org/), [NodeJs](https://nodejs.org/en), [Xampp](https://www.apachefriends.org/download.html). Setelah semua sudah ter-install pastikan anda telah melakukan configurasi git di local, contoh :

```bash
git config --global user.email "example@gmail.com"
```

```bash
git config --global user.name "exampleusername"
```

Kemuadian jika sudah buka terminal anda dan clone project dari github ke local.

```bash
git clone https://github.com/tefa-stemanika/stemanika-laravel.git
```

## Installation

pastikan anda sudah berada pada direktori/folder project. Jika belum anda bisa langsung pindah pada direktori project dengan menjalankan perintah ini pada terminal anda :

```bash
cd stemanika-laravel
```

jika sudah berada pada direktori project, lakukan perintah :

```bash
composer install
```

selanjutnya jalankan printah ini untuk menginstall semua dependensi yang dibutuhkan "

```bash
npm install
```

## Usage

Jika semuanya sudah terinstall dengan baik dan tidak terjadi masalah/error, selanjutnya tinggal menjalankan project anda di local. Jalankan 2 (dua) perintah ini secara bersamaan di terminal anda dengan cara membuka 2 terminal.

```bash
npm run dev
```

perintah diatas adalah untuk menjalankan server nodejs, agar Tailwindcss bisa terbaca oleh laravel.

```bash
php artisan serve
```

perintah diatas adalah untuk menjalankan server Laravel.

Kemuadian lakukan migrasi database, pastikan server xampp anda sudah berjalan dan juga ubah nama file .env.example manjadi .env, jika sudah, pada bagian key DB_DATABASE yang ada pada file .env anda bisa mengatur nama database yang anda mau disini. Jika semua sudah siap, jalankan perintah ini di terminal anda :

```bash
php artisan migrate --seed
```

Project sudah bisa dilihat pada [http://127.0.0.1:8000](http://127.0.0.1:8000).

## Push Project

ketika anda ingin melakukan push project dari local ke public anda harus melakukan beberapa proses-proses sebagai berikut :

### Buat branch (cabang)

buat branch untuk menandai bahwa perubahan yang ada itu adalah milik anda karena kita mengerjakan secara tim. Kemudian branch seperti namanya yaitu cabang, yang artinya jika kita ingin mengubah branch (cabang) utama kita tidak boleh mengubah langsung pada branch (utama) karena itu akan berpotensi merusak branch utama yang sudah berisi fitur-fitur yang sudah siap untuk dipakai.

cara membuat branch :

```bash
git branch nama-banch
```

karena kita bekerja secara tim, mari kita buat pola untuk penamaan branch itu sendiri, contohnya :

```bash
git branch dev-nama

contoh:
git branch dev-zheka
```

kemudian jika sudah, pastikan bahwa anda sudah berada pada branch dengan nama anda dengan cara :

```bash
git checkout nama-branch

contoh 1:
git checkout dev-zheka

contoh 2:
git checkout main
```

### Commit

commit dapat kita analogikan seperti save, ketika kita sudah melakukan perubahan, untuk menyimpan perubahan itu agar tersimpan kita dapat melakukan save atau dalam hal ini kita dapat menyebunya commit. Namun sebelum anda melakukan commit, anda perlu melakukan git add terlebih dahulu. Dalam git ada yang namanya _staging area_, git (save/commit) hanya dapat menyimpan perubahan file yang berada pada _staging area_, jadi sebelum melakukan save/commit, anda perlu melakukan git add terlebih dahulu.

```bash
git add tailwind.config.js

penjelasan:
artinya menambahkan perubahan yang ada pada file tailwind.config.js.
Namun itu hanya menambahkan satu file kedalam staging area, bagiamana jika file yang akan kita tambahkan sangat banyak?.
Kita dapat melakukan tanda . (titik) untuk menambahkan semua perubahan yang ada kedalam staging area, contoh:

git add .
```

kemudian setelah berhasil melakukan git add, anda bisa melakukan commit.

```bash
git commit -m "pesan commit"

contoh:
git commit -m "menambahkan halaman login"
```

### Push ke github

push berarti mengirim dari local ke public, git push akan mengirim perubahan yang sudah tersimpan/ter-commit, jadi pastikan terlebih dahulu perubahan yang akan anda publish sudah ter-commit.

```bash
git push -u origin namabranch

contoh:
git push -u origin dev-zheka
```

anda hanya dapat melakukan git push dengan branch anda sendiri, karena jika anda melakukan git push melalui branch main akan berpotensi merusak project utama. **Contoh salah :**

```bash
git push -u origin main
```

sampai disini Push Project anda sudah selesai, anda bisa memeriksa apakah branch anda sudah ter-publish pada halaman ini [https://github.com/tefa-stemanika/stemanika-laravel/branches](https://github.com/tefa-stemanika/stemanika-laravel/branches)
