<?php

namespace App\Http\Controllers\Admin;

use App\Helper\CommonHelper;
use App\Http\Controllers\Controller;
use App\Models\Ekstrakulikuler;
use App\Http\Requests\EkskulStoreRequest;
use App\Http\Requests\EkskulUpdateRequest;
use Illuminate\Http\Request;
use Illuminate\View\View;

class EkstrakulikulerController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(): View
    {
        $ekstrakulikuler = Ekstrakulikuler::latest()->paginate(12);

        return view('pages.admin.ekstrakulikuler.index', [
            'ekstrakulikuler' => $ekstrakulikuler
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view("pages.admin.ekstrakulikuler.create");
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(EkskulStoreRequest $request)
    {
        $uploadedImage = CommonHelper::storeImage($request->validated('image'), 'EKSKUL');
        $slug = CommonHelper::generateSlug($request->validated('slug'));

        Ekstrakulikuler::create([
            'image' => $uploadedImage,
            'name' => $request->validated('name'),
            'slug' => $slug,
            'description' => $request->validated('description'),
            'show' => $request->validated('show') === 'on'
        ]);

        return redirect()->route('admin.ekstrakulikuler')->with('success', 'Ekstrakulikuler berhasil ditambah');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id): View
    {
        $ekstrakulikuler = Ekstrakulikuler::find($id);

        return view('pages.admin.ekstrakulikuler.update', [
            'ekstrakulikuler' => $ekstrakulikuler
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(EkskulUpdateRequest $request, string $id)
    {
        $ekstrakulikuler = Ekstrakulikuler::find($id);

        if ($request->has('image')) {
            $uploadedImage = CommonHelper::updateImage($request->validated('image'), $ekstrakulikuler->image, 'EKSKUL');
        } else {
            $uploadedImage = $ekstrakulikuler->image;
        }

        $slug = CommonHelper::generateSlug($request->validated('name'));

        $ekstrakulikuler->update([
            'image' => $uploadedImage,
            'name' => $request->validated('name'),
            'slug' => $slug,
            'description' => $request->validated('description'),
            'show' => $request->validated('show') === 'on'
        ]);

        return redirect()->route('admin.ekstrakulikuler')->with('success', 'Ekstrakulikuler berhasil diperbarui');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $ekstrakulikuler = Ekstrakulikuler::findOrFail($id);

        if ($ekstrakulikuler->image) {
            CommonHelper::deleteImage($ekstrakulikuler->image, 'EKSKUL');
        }

        $ekstrakulikuler->delete();

        return back();
    }
}
