<?php

namespace App\Http\Controllers\Admin;

use App\Helper\CommonHelper;
use App\Http\Controllers\Controller;
use App\Http\Requests\FasilitasStoreRequest;
use App\Http\Requests\FasilitasUpdateRequest;
use App\Models\Fasilitas;
use Illuminate\Http\Request;
use Illuminate\View\View;

class FasilitasController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(): View
    {
        $fasilitas = Fasilitas::latest('created_at')->paginate(12);

        return view('pages.admin.fasilitas.index', [
            'fasilitas' => $fasilitas
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(): View
    {
        return view('pages.admin.fasilitas.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(FasilitasStoreRequest $request)
    {
        $image = CommonHelper::storeImage($request->validated('image'), 'FASILITAS');

        $slug = CommonHelper::generateSlug($request->validated('name'));

        Fasilitas::create([
            'name' => $request->validated('name'),
            'image' => $image,
            'slug' => $slug,
            'description' => $request->validated('description'),
            'show' => $request->validated('show') === 'on',
        ]);

        return redirect()->route('admin.fasilitas');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id): View
    {
        $fasilitas = Fasilitas::find($id);

        return view('pages.admin.fasilitas.update', [
            'fasilitas' => $fasilitas
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(FasilitasUpdateRequest $request, string $id)
    {
        $fasilitas = Fasilitas::find($id);

        // memberikan kondisi jika data fasilitas yang dicari menggunakan id tidak ada maka akan dikembalikan kehalaman sebelumnya.
        if (!$fasilitas->exists()) {
            return back();
        }

        if ($request->has('image')) {
            $image = CommonHelper::updateImage($request->validated('image'), $fasilitas->image, 'FASILITAS');
        } else {
            $image = $fasilitas->image;
        }

        $slug = CommonHelper::generateSlug($request->validated('name'));

        $fasilitas->update([
            'name' => $request->validated('name'),
            'image' => $image,
            'slug' => $slug,
            'description' => $request->validated('description'),
            'show' => $request->validated('show') === 'on',
        ]);

        return redirect()->route('admin.fasilitas');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $fasilitas = Fasilitas::find($id);

        if ($fasilitas->exists()) {
            // Melakukan pengecekan apakah data image ada atau tidak null dan file image tersedia 
            if ($fasilitas->image) {
                CommonHelper::deleteImage($fasilitas->image, 'FASILITAS');
            }

            $fasilitas->delete();
        }

        return back();
    }
}
