<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\View\View;
use App\Models\Blog;

class BlogController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(): View
    {

        return view('pages.user.blog', [
            'blogs' => Blog::latest()->paginate(9)
        ]);
    }

    // menampilkan detail dari sebuah blog
    public function detail($slug)
    {
        return view('pages.user.detail-blog', [
            'blog' => Blog::where('slug', $slug)->firstOrFail(),
            'blogs' => Blog::latest()->paginate(5)
        ]);
    }
}
