<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class EkskulStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'image' => ['required', 'mimes:png,jpg,svg,jpeg'],
            'name' => ['required', 'string', 'max:255','unique:ekstrakulikuler,name'],
            'description' => ['required', 'string'],
            'show' => ['nullable'],
        ];
    }
}
