<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreEkskul extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'image' => ['required', 'mimes:png,jpg,jpeg,svg'],
            'name' => ['required', 'string', 'max:255', 'unique:ekstrakulikuler,name'],
            'description' => ['required', 'string'],
        ];
    }

    public function messages(): array
    {
        return [
            'image.required' => ':attribute dibutuhkan',
            'image.mimes' => ':attribute hanya dapat bertipe: png, jpg, jpeg, svg',

            'name.required' => ':attribute dibutuhkan',
            'name.string' => ':attribute harus berupa teks',
            'name.string' => ':attribute tidak boleh melebihi 255 karakter',
            'name.unique' => ':attribute sudah tersedia',

            'description.required' => ':attribute dibutuhkan',
            'description.string' => ':attribute harus berupa teks',
        ];
    }
}
