<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateJurusan extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $id = $this->route('id');

        return [
            'logo' => ['nullable', 'mimes:png,jpg,jpeg,svg'],
            'name' => ['required', 'string', 'max:255', Rule::unique('jurusan', 'name')->ignore('id', $id)],
            'description' => ['required', 'string'],
        ];
    }

    public function messages(): array
    {
        return [
            'logo.mimes' => ':attribute hanya dapat bertipe: png, jpg, jpeg, svg',

            'name.required' => ':attribute dibutuhkan',
            'name.string' => ':attribute harus berupa teks',
            'name.string' => ':attribute tidak boleh melebihi 255 karakter',
            'name.unique' => ':attribute sudah tersedia',

            'description.required' => ':attribute dibutuhkan',
            'description.string' => ':attribute harus berupa teks',
        ];
    }
}
