<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Comment extends Model
{
    use HasFactory, HasUuids;

    protected $guarded = ['id'];

    protected $keyType = 'string';

    protected $fillable = [
        'name',
        'email',
        'body',
        'blog_id'
    ];

    public function blog()
    {
        return $this->belongsTo(Blog::class);
    }
}
