<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Jurusan extends Model
{
    use HasFactory, HasUuids;

    protected $table = 'jurusan';

    protected $guarded = ['id'];

    protected $keyType = 'string';

    protected $fillable = [
        'logo',
        'name',
        'slug',
        'description'
    ];

    private static $jurusan = [
        [
            'id' => 1,
            'logo' => 'images/bg-sekolah.jpg',
            'name' => 'DPIB',
            'slug' => 'desain-perancangan-dan-informasi-bangunan',
            'description' => 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Possimus nam tempora porro commodi perferendis, vel eveniet illum qui necessitatibus fugiat impedit, tempore ratione reprehenderit debitis! Dolorem ullam odit aliquid necessitatibus?'
        ],
        [
            'id' => 2,
            'logo' => 'images/bg-sekolah.jpg',
            'name' => 'TITL',
            'slug' => 'teknik-instalasi-tenaga-listrik',
            'description' => 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Possimus nam tempora porro commodi perferendis, vel eveniet illum qui necessitatibus fugiat impedit, tempore ratione reprehenderit debitis! Dolorem ullam odit aliquid necessitatibus?'
        ],
        [
             'id' => 3,
            'logo' => 'images/bg-sekolah.jpg',
            'name' => 'TKR',
            'slug' => 'teknik-kendaraan-ringan',
            'description' => 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Possimus nam tempora porro commodi perferendis, vel eveniet illum qui necessitatibus fugiat impedit, tempore ratione reprehenderit debitis! Dolorem ullam odit aliquid necessitatibus?'
        ],
        [
             'id' => 4,
            'logo' => 'images/bg-sekolah.jpg',
            'name' => 'TSM',
            'slug' => 'teknik-sepeda-motor',
            'description' => 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Possimus nam tempora porro commodi perferendis, vel eveniet illum qui necessitatibus fugiat impedit, tempore ratione reprehenderit debitis! Dolorem ullam odit aliquid necessitatibus?'
        ],
        [
            'id' => 5,
            'logo' => 'images/bg-sekolah.jpg',
            'name' => 'TPM',
            'slug' => 'teknik-pemesinan',
            'description' => 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Possimus nam tempora porro commodi perferendis, vel eveniet illum qui necessitatibus fugiat impedit, tempore ratione reprehenderit debitis! Dolorem ullam odit aliquid necessitatibus?'
        ],
        [
            'id' => 6,
            'logo' => 'images/bg-sekolah.jpg',
            'name' => 'RPL',
            'slug' => 'rekayasa-perangkat-lunak',
            'description' => 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Possimus nam tempora porro commodi perferendis, vel eveniet illum qui necessitatibus fugiat impedit, tempore ratione reprehenderit debitis! Dolorem ullam odit aliquid necessitatibus?'
        ],
        [
            'id' => 7,
            'logo' => 'images/bg-sekolah.jpg',
            'name' => 'TKJ',
            'slug' => 'teknik-komputer-dan-jaringan',
            'description' => 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Possimus nam tempora porro commodi perferendis, vel eveniet illum qui necessitatibus fugiat impedit, tempore ratione reprehenderit debitis! Dolorem ullam odit aliquid necessitatibus?'
        ],
    ];

    public static function jurusan() {
        return collect (self::$jurusan);
    }
}
