@extends('components.layout.admin.container')

@section('title', 'Ekstrakulikuler')

@section('links')
    
@endsection

@section('main')
    <section class="mx-[100px] my-[150px]">
        <div class="flex items-center justify-between">
            <h1 class="text-3xl font-bold text-dark">Ekstrakulikuler</h1>
            <a href="{{ route('admin.ekstrakulikuler.create') }}" class="flex items-center gap-2.5 bg-dark py-2.5 px-5 rounded-[5px]">
                <img src="{{ asset('icons/plus.svg') }}" alt="plus icon" width="20" height="20" loading="lazy">
                <p class="text-white text-lg font-bold">Tambah Ekstrakulikuler</p>
            </a>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-4 gap-10 mt-[30px] mb-10">
            @foreach ($ekstrakulikuler as $item)   
                <div class="bg-white drop-shadow-md rounded-[10px]">
                    <img src="{{ asset($item->image) }}" alt="" width="302" height="220" class=" w-full h-auto rounded-t-[10px]" loading="lazy" >

                    <div class="p-5 space-y-[5px]">
                        <h3 class=" text-black text-sm font-bold line-clamp-2">
                            {{ $item->name }}
                        </h3>

                        <div class="flex items-center justify-between gap-x-6">
                            <time class="text-xs text-[#888888]">{{ $item->created_at ?? '28 Juni 2006' }}</time>
                            <div class="flex items-center gap-x-5 text-xs {{ $item->show ? 'text-green-500' : 'text-red-500' }}">
                                {{ $item->show ? 'show' : 'hidden' }}
                            </div>
                        </div>

                        <p class="text-[#4F4F4F] text-sm line-clamp-4">
                            {{ $item->description }}
                        </p>
                        
                        <div class="flex items-center gap-9 pt-4">
                            <a href="{{ route('admin.ekstrakulikuler.edit', $item->id) }}" class="text-sm font-medium text-sky-500">Update</a>
                            <form action="{{ route('admin.ekstrakulikuler.destroy', $item->id) }}" method="post" id="delete_form">
                                @csrf @method('DELETE')
                                <button type="submit" class="text-sm font-medium text-red-500">Delete</button>
                            </form>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
        {{ $ekstrakulikuler->appends(request()->query())->links() }}
    </section>
@endsection

@section('scripts')
    <script>
        const deleteForm = document.querySelectorAll('#delete_form')

        deleteForm.forEach((e) => {
            e.onsubmit = () => {
                if (!confirm('Apakah anda yakin ingin menghapus ekstrakulikuler ini?')) {
                    return false
                }
                return true
            }
        })
    </script>
@endsection