@extends('components.layout.admin.container')

@section('title', 'Blog')

@section('links')
    <style>
        .ck-editor__editable[role="textbox"] {
            /* Editing area */
            min-height: 200px;
        }
    </style>
@endsection

@section('main')
    <section class="mx-[100px] my-[150px]">
        <div class="flex"> 
            <p class="font-base flex items-center text-xl font-medium">
                <a href="{{ url()->previous() }}">
                    <i class="bg-black flex items-center justify-center p-1 size-auto rounded-[5px] text-white me-4" data-feather="chevron-left"></i>
                </a>
                Kembali
            </p>
        </div>

        @if ($errors->any())
            <div>
                <h3 class="text-red-500 text-xl font-bold">Beberapa error ketika mencoba menyimpan data:</h3>
                <ol class="list-decimal list-inside">
                    @foreach ($errors->all() as $error)
                        <li class="text-red-500 text-base font-medium">{{ $error }}</li>
                    @endforeach
                </ol>
            </div>
        @endif

        <form method="POST" action="{{ route('admin.fasilitas.store') }}" id="container" enctype="multipart/form-data" class="grid grid-cols-1 gap-6 mt-14">
            @csrf @method('POST')
            <div class="space-y-1.5">
                <div class="aspec-[4/3] max-w-3xl mx-auto">
                    <img src="https://fakeimg.pl/600x400" id="image_preview" width="768" height="500" loading="lazy" class="object-center object-cover size-full rounded-md">
                </div>
                <label for="image" class="text-dark font-medium text-base block">image</label>
                <input type="file" accept=".png, .svg, .jpeg, jpg" onchange="previewLogo(event)" name="image" id="image" class="border border-[#ccced1] p-2 rounded w-full">
            </div>
            <div class="space-y-1.5">
                <label for="name" class="text-dark font-medium text-base block">name</label>
                <input type="text" name="name" id="name" class="border border-[#ccced1] p-2 rounded w-full">
            </div>
            <div class="space-y-1.5">
                <label for="description" class="text-dark font-medium text-base block">description</label>
                <textarea name="description" id="description" cols="30" rows="10"></textarea>
            </div>
            <div class="flex items-center gap-x-4">
                <label for="show" class="text-dark font-medium text-xl block">show</label>
                <input type="checkbox" name="show" id="show" class="size-4 accent-green-400" checked>
            </div>
            <div class="space-y-1.5">
                <button type="submit" class="bg-dark px-6 py-1.5 rounded-md text-white text-base font-medium">submit</button>
            </div>
        </form>
    </section>
@endsection

@section('scripts')
    <script src="https://cdn.ckeditor.com/ckeditor5/41.4.2/classic/ckeditor.js"></script>

    <script>
        ClassicEditor
            .create( document.querySelector( '#description' ), {
                toolbar: {
                    items: [
                        'undo', 'redo', '|', 'bold', 'italic', '|'
                    ]
                }

            } )
            .catch( error => {
                console.log( error );
            });

        function previewLogo(event) {
            const input = event.target;
            const preview = document.getElementById('image_preview');

            if (input.files && input.files[0]) {
                const reader = new FileReader();

                reader.onload = function (e) {
                    preview.src = e.target.result;
                };

                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endsection