@extends('components.layout.user.container')

@section('title', 'Jurusan')

@section('links')
    <link rel="stylesheet"href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/>

@endsection

{{-- Main Content --}}                                                                                                                                                                      
@section('main')
    <section class=" mx-[100px] mt-[100px]">
        <div class="">
            <h1 class=" font-bold text-[32px]">Jurusan</h1>
            <p class="text-[18px]">
                SMKN 1 Majalengka menawarkan tujuh jurusan unggulan: Desain Pemodelan dan Informasi Bangunan (DPIB), Teknik Ketenagalistrikan (TKL), Teknik Mesin (TM), Teknik Otomotif (TO), Teknik Sepeda Motor (TSM), Rekayasa Perangkat Lunak (RPL), dan Teknik Komputer dan Jaringan (TKJ), memberikan pendidikan berkualitas dengan fasilitas lengkap.
            </p>
        </div>

    <section id="fasilitas" class="mt-[50px]">
        <div class="grid grid-cols-1 lg:grid-cols-4 gap-14">
            @foreach ($jurusan as $j)
                <div class="relative bg-dark rounded-[10px] overflow-hidden" key="">
                    <img src="{{ $j['logo'] }}" alt="" class="object-cover object-center w-full h-auto rounded-[5px] aspect-video" loading="lazy">
                    <div class="absolute inset-0 p-6 flex flex-col items-center justify-between bg-gradient-to-t from-dark/90">
                        <h3 class="invisible text-center text-white text-lg font-medium">{{ $j['name'] }}</h3>
                        <h3 class="text-center text-white text-lg font-medium">{{ $j['name'] }}</h3>
                        <a class="bg-white/80 rounded-md w-full py-2 text-center text-black text-base font-medium">Selengkapnya</a>
                    </div>
                </div>
            @endforeach
        </div>
    </section>
@endsection
{{-- Main Content --}}

@section('scripts')
@endsection