<?php

use App\Mail\VerifySubsMail;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [App\Http\Controllers\User\HomeController::class, 'index'])->name('home');
Route::get('/profile', [App\Http\Controllers\User\ProfileController::class, 'index'])->name('profile');
Route::get('/fasilitas', [App\Http\Controllers\FasilitasController::class, 'index'])->name('fasilitas');
Route::get('/jurusan', [App\Http\Controllers\JurusanController::class, 'index'])->name('jurusan');
Route::get('/ekstrakulikuler', [App\Http\Controllers\EkstrakulikulerController::class, 'index'])->name('ekstrakulikuler');

Route::get('/blog', [App\Http\Controllers\User\BlogController::class, 'index'])->name('blog');
Route::get('/blog/{slug}', [App\Http\Controllers\User\BlogController::class, 'detail'])->name('detail.blog');

Route::middleware([])->prefix('admin')->group(function () {
    Route::get('/dashboard', [App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('admin.dashboard');

    //? Blog
    Route::get('/blog', [App\Http\Controllers\Admin\BlogController::class, 'index'])->name('admin.blog');
    Route::get('/blog/create', [App\Http\Controllers\Admin\BlogController::class, 'create'])->name('admin.blog.create');
    Route::post('/blog/store', [App\Http\Controllers\Admin\BlogController::class, 'store'])->name('admin.blog.store');
    Route::get('/blog/{id}/edit', [App\Http\Controllers\Admin\BlogController::class, 'edit'])->name('admin.blog.edit');
    Route::put('/blog/{id}/update', [App\Http\Controllers\Admin\BlogController::class, 'update'])->name('admin.blog.update');
    Route::delete('/blog/{id}/destroy', [App\Http\Controllers\Admin\BlogController::class, 'destroy'])->name('admin.blog.destroy');

    //? Fasilitas
    Route::get('/fasilitas', [App\Http\Controllers\Admin\FasilitasController::class, 'index'])->name('admin.fasilitas');

    // Ekstrakulikuler
    Route::get('/ekstrakulikuler', [App\Http\Controllers\Admin\EkstrakulikulerController::class, 'index'])->name('admin.ekstrakulikuler');
    Route::get('/ekstrakulikuler/create', [App\Http\Controllers\Admin\EkstrakulikulerController::class, 'create'])->name('admin.ekstrakulikuler.create');
    Route::post('/ekstrakulikuler/store', [App\Http\Controllers\Admin\EkstrakulikulerController::class, 'store'])->name('admin.ekstrakulikuler.store');
    Route::get('/ekstrakulikuler/{id}/edit', [App\Http\Controllers\Admin\EkstrakulikulerController::class, 'edit'])->name('admin.ekstrakulikuler.edit');
    Route::put('/ekstrakulikuler/{id}/update', [App\Http\Controllers\Admin\EkstrakulikulerController::class, 'update'])->name('admin.ekstrakulikuler.update');
    Route::delete('/ekstrakulikuler/{id}/destroy', [App\Http\Controllers\Admin\EkstrakulikulerController::class, 'destroy'])->name('admin.ekstrakulikuler.destroy');

    //  Fasilitas
    Route::get('/fasilitas/create', [App\Http\Controllers\Admin\FasilitasController::class, 'create'])->name('admin.fasilitas.create');
    Route::post('/fasilitas/store', [App\Http\Controllers\Admin\FasilitasController::class, 'store'])->name('admin.fasilitas.store');
    Route::get('/fasilitas/{id}/edit', [App\Http\Controllers\Admin\FasilitasController::class, 'edit'])->name('admin.fasilitas.edit');
    Route::put('/fasilitas/{id}/update', [App\Http\Controllers\Admin\FasilitasController::class, 'update'])->name('admin.fasilitas.update');
    Route::delete('/fasilitas/{id}/destroy', [App\Http\Controllers\Admin\FasilitasController::class, 'destroy'])->name('admin.fasilitas.destroy');

    Route::get('/ekstrakulikuler', [App\Http\Controllers\Admin\EkstrakulikulerController::class, 'index'])->name('admin.ekstrakulikuler');

    Route::post('/ckeditor/upload', [App\Http\Controllers\CkeditorUploadController::class, 'upload'])->name('ckeditor.upload');
    Route::get('/logout', function () {
        auth()->logout();
    })->name('logout');
});

// Route::get('/dashboard', function () {
//     $token = '01920912912';
//     $email = 'zhekabaila@gmail.com';

//     $link = url('subscribe/' . $token . '/' . $email);

//     Mail::to('zhekabaila@gmail.com')->send(new VerifySubsMail('Verifikasi Subscriber SMK Negeri 1 Majalengka', $link));

//     return 'asdf';
// });

// Route::get('/', [App\Http\Controllers\SubscriberController::class, 'subscriber_form'])->name('form');
Route::post('/subscriber', [App\Http\Controllers\SubscriberController::class, 'index'])->name('subscribe');
Route::get('/subscriber/verify/{token}/{email}', [App\Http\Controllers\SubscriberController::class, 'verify'])->name('subscriber_verify');

// Message to All Subscriber

Route::get('/subscriber/all', [App\Http\Controllers\AdminSubscriberController::class, 'show_all'])->name('admin_subscribers');
Route::get('/subscriber/send-email', [App\Http\Controllers\AdminSubscriberController::class, 'send_email'])->name('subscriber_send_email');
Route::post('/admin/subscriber/send-email-submit', [App\Http\Controllers\AdminSubscriberController::class, 'send_email_submit'])->name('subscriber_send_email_submit');
